<?php

declare(strict_types=1);

namespace Erlage\Photogram\Tools;

final class Crypto
{
    public static function databaseHashFromClearPassword(string $clearPassword): string
    {
        return \password_hash($clearPassword, PASSWORD_BCRYPT);
    }

    public static function verifyClearPasswordWithDatabaseHash(string $clearPassword, string $databaseHash): bool
    {
        return \password_verify($clearPassword, $databaseHash);
    }

    public static function randomString(int $length, bool $strong = true): string
    {
        /*
        |--------------------------------------------------------------------------
        | if Open SSL functions exists, use them
        |--------------------------------------------------------------------------
        */
        if ($strong && \function_exists('openssl_random_pseudo_bytes'))
        {
            return \substr(\str_shuffle(\bin2hex(\openssl_random_pseudo_bytes(16))), 0, $length);
        }

        /*
        |--------------------------------------------------------------------------
        | else try to generate a random string AS SECURE AS POSSIBLE!
        |--------------------------------------------------------------------------
        */
        if ($strong)
        {
            return \substr(
                \str_shuffle(
                    \random_int(11001, 99999)
                    . \str_shuffle('CeNVAsa3EpV23YR2')
                    . \random_int(11001, 99999)
                    . \str_shuffle('85mvKqOgcSZfGSGy')
                    . \random_int(11001, 99999)
                    . \str_shuffle('fS9n_Pli4BSUtD6X')
                    . \random_int(11001, 99999)
                    . \str_shuffle('GFGSJ1kIhxM0HoTz')
                    . \random_int(11001, 99999)
                    . \str_shuffle('Fd."90d$fad18ZgQ')
                    . \random_int(11001, 99999)
                    . \str_shuffle('9Tk<!7EZvasdLPad')
                    . \random_int(11001, 99999)
                    . \str_shuffle('hKd9C+YXyLasds4b')
                ),
                0,
                $length
            );
        }

        /*
        |--------------------------------------------------------------------------
        | else generate a medium strenth random string
        |--------------------------------------------------------------------------
        */

        return \substr(\str_shuffle('CeNVAsa3EpYR285mvKqOgcZfy9n_Pli4BSUtD6XGFJ1kIhxM0HoTzubrQd7Lj' . \random_int(11001, 99999)), 0, $length);
    }

    public static function randomOTP(): string
    {
        /**
         * Security note:
         * 
         * We're using php's inbuilt function 'random_int()' to generate a random integer
         * of desired length(6) It's important to note that function alone is a secure
         * and solid implementation.
         * 
         * But still, we've tried to increase the randomness by invoking the same built-in 
         * function multiple times over multiple passes.
         * 
         * Level one passes generate random set of integers(at least 12 OTPs)
         *  - using random_int()
         * 
         * Level two passses shuffle those integers(at least 3 times)
         *  - using random_int()
         * 
         * Final pass selects a random entry from random otps
         *  - using array_rand()
         * 
         */

        $randomeOtps = array();

        /**
         * level one passes
         */

        $passesLevelOne = \random_int(12, 24);

        while ($passesLevelOne--)
        {
            $randomeOtps[] = \random_int(111111, 999999);
        }

        /**
         * level two passes...
         */

        $passesLevelTwo = \random_int(3, 6);

        while ($passesLevelTwo--)
        {
            \shuffle($randomeOtps);
        }

        /**
         * final pass
         */

        return (string) $randomeOtps[\array_rand($randomeOtps)];
    }
}
